/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.telnet;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.eui.PropertySection;
import ibm.nways.jdm.eui.StringInputRO;
import ibm.nways.telnet.TelnetContext;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;

public class TelnetPanel
extends DestinationPropBook {
    private static ResourceBundle enumStrings = null;
    private static ResourceBundle myResources = null;
    private TelnetContext telnetContext;
    protected Properties properties;
    protected static final String PropertiesFile = "properties/Telnet.txt";
    private static String title = "Telnet";
    protected telnetSection telnetPropertySection;

    private static void loadStatics() {
        try {
            if (enumStrings == null) {
                enumStrings = ResourceBundle.getBundle("ibm.nways.telnet.EnumeratedResources");
            }
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to access translation resources for panel Telnet");
        }
    }

    public String getDestinationTitle() {
        return TelnetPanel.getTitle();
    }

    public static String getTitle() {
        TelnetPanel.loadStatics();
        if (myResources != null) {
            title = TelnetPanel.getNLSString("TelnetPanelTitle");
        }
        return title;
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public TelnetPanel() {
        TelnetPanel.loadStatics();
    }

    public void addSections() {
        NavigationContext navigationContext = this.getNavContext();
        this.telnetContext = (TelnetContext)navigationContext.get("telnetContext");
        try {
            BrowserApplet browserApplet = this.getBrowser();
            URL uRL = new URL(browserApplet.getDocumentBase(), PropertiesFile);
            System.out.println("DocumentBase = " + browserApplet.getDocumentBase());
            this.properties = new Properties();
            this.properties.load(uRL.openStream());
        }
        catch (Exception exception) {
            System.out.println("Error getting TELNET Properties: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.telnetPropertySection = new telnetSection(this.telnetContext);
        this.addSection(TelnetPanel.getNLSString("telnetSectionTitle"), this.telnetPropertySection);
        this.addApplyButton();
        this.addRefreshButton();
        this.addHelpButton();
    }

    protected static String getNLSString(String string) {
        if (myResources == null) {
            return string;
        }
        try {
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private class telnetSection
    extends PropertySection {
        BrowserApplet browser;
        String urlString = new String("telnet://");
        TelnetContext telnetContext;
        StringInputRO telnetField = new StringInputRO();

        public telnetSection(TelnetContext telnetContext) {
            TelnetPanel.this = TelnetPanel.this;
            this.telnetContext = telnetContext;
            this.setLayout(new GridBagLayout());
            this.setLayout(new GridBagLayout());
            this.setInsets(new Insets(5, 5, 5, 5));
            this.browser = TelnetPanel.this.getBrowser();
            this.addRow(TelnetPanel.getNLSString("telnetLabel"), (Component)this.telnetField);
            this.urlString = this.urlString.concat(this.telnetContext.getIpAddress());
            System.out.println("URL to open = " + this.urlString);
            this.telnetField.setText(this.urlString);
            this.reset();
        }

        private String trimQuotes(String string) {
            String string2 = string;
            if (string2 != null && string2.trim() != null) {
                int n;
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"") && (n = string2.lastIndexOf("\"")) != -1) {
                    string2 = string2.substring(0, n);
                }
            }
            return string2;
        }

        public void apply() {
            String string = System.getProperty("os.name");
            System.out.println("Telnet session: os.name=" + string);
            String string2 = null;
            String string3 = null;
            if (this.browser.getIsApplication()) {
                if (TelnetPanel.this.properties != null) {
                    try {
                        if (string.equals("Windows NT")) {
                            string3 = (String)((Hashtable)TelnetPanel.this.properties).get("NT_TELNET");
                            String[] stringArray = new String[]{string3, this.telnetContext.getIpAddress()};
                            System.out.println("telnet=" + stringArray[0]);
                            Runtime.getRuntime().exec(stringArray);
                            return;
                        }
                        string3 = (String)((Hashtable)TelnetPanel.this.properties).get("UNIX_TELNET");
                        string3 = this.trimQuotes(string3);
                        string2 = (String)((Hashtable)TelnetPanel.this.properties).get("UNIX_TELNET_SCRIPT");
                        string2 = this.trimQuotes(string2);
                        String[] stringArray = new String[]{string2, string3, this.telnetContext.getIpAddress()};
                        System.out.println("fullPathScriptStr(cmdArray[0])=" + stringArray[0]);
                        System.out.println("telnet(cmdArray[1])=" + stringArray[1]);
                        Runtime.getRuntime().exec(stringArray);
                        return;
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        exception.printStackTrace();
                        return;
                    }
                }
            } else {
                try {
                    this.browser.launchWebBrowser(this.telnetField.getText());
                    return;
                }
                catch (Exception exception) {
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                    return;
                }
            }
        }

        public void reset() {
            this.doLayout();
        }
    }
}

